/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import junit.framework.TestCase;
import woolpack.AllTests;
import woolpack.TestUtils;
import woolpack.utils.UtilsConstants;

public class JoinProcessTest extends TestCase {
	private final ExecutorService threadPool = Executors.newFixedThreadPool(AllTests.MAX_THREAD);
	boolean flag;

	public void testConstructor(){
		try{
			new JoinProcess(null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new JoinProcess("", DomConstants.NULL);
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new JoinProcess("key0", null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	private void scenario(final DomExpression expression, final ConcurrentMap<String,Object> session) throws InterruptedException{
		flag = true;
		final CountDownLatch latch = new CountDownLatch(AllTests.MAX_THREAD);
		for(int i=0; i<AllTests.MAX_THREAD; i++){
			threadPool.execute(new Runnable(){
				public void run() {
					try{
						final DomContext context = new DomContext();
						context.setId("id0");
						context.setSession(session);
						expression.interpret(context);
						synchronized(this){
							flag &= TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"value0\" />");
						}
					}finally{
						latch.countDown();
					}
				}
			});
		}
		latch.await();
		assertTrue(flag);
	}
	
	public void testNormal() throws InterruptedException{
		final Count counter0 = new Count(new Sleep(5, 5, TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />")));
		final DomExpression expression = new JoinProcess(counter0);
		
		for(int i=0; i<AllTests.TEST_COUNT; i++){
			final ConcurrentMap<String,Object> session = UtilsConstants.concurrentMap(new HashMap<String,Object>(), new Object());
			scenario(expression, session);
			assertEquals(i+1, counter0.getCount());
		}
	}
}
