/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import woolpack.action.ForwardMatcher;
import woolpack.action.NotForwardMatcher;
import junit.framework.TestCase;

public class NotForwardMatcherTest extends TestCase {

	public void testConstructor(){
		try{
			new NotForwardMatcher(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal(){
		final ForwardMatcher matcher = new ForwardMatcher("a");
		final NotForwardMatcher notMatcher = new NotForwardMatcher(matcher);
		assertEquals(matcher, notMatcher.getDelegate());
		assertTrue(notMatcher.matches(null));
		assertFalse(notMatcher.matches("a"));
		assertTrue(notMatcher.matches("b"));
		assertTrue(notMatcher.matches(new Exception()));
		assertTrue(notMatcher.matches(new RuntimeException()));
		assertTrue(notMatcher.matches(new IndexOutOfBoundsException()));
		assertTrue(notMatcher.matches(new ArrayIndexOutOfBoundsException()));
	}
}
