/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.action.ActionAllTests;
import woolpack.adapter.AdapterAllTests;
import woolpack.config.ConfigAllTests;
import woolpack.container.ContainerAllTests;
import woolpack.dom.DomAllTests;
import woolpack.ee.EEAllTests;
import woolpack.el.ElAllTests;
import woolpack.html.HtmlAllTests;
import woolpack.locale.LocaleAllTests;
import woolpack.text.TextAllTests;
import woolpack.utils.UtilsAllTests;
import woolpack.validator.ValidatorAllTests;

public class AllTests extends TestCase {
	public static final int MAX_CONCURRENT = 2;
	public static final int MAX_THREAD = 5;
	public static final int TEST_COUNT = 100;
	public static final int TEST_THRESHOLD = 20;

	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(ActionAllTests.suite());
		suite.addTest(AdapterAllTests.suite());
		suite.addTest(ConfigAllTests.suite());
		suite.addTest(ContainerAllTests.suite());
		suite.addTest(DomAllTests.suite());
		suite.addTest(EEAllTests.suite());
		suite.addTest(ElAllTests.suite());
		suite.addTest(HtmlAllTests.suite());
		suite.addTest(LocaleAllTests.suite());
		suite.addTest(TextAllTests.suite());
		suite.addTest(UtilsAllTests.suite());
		suite.addTest(ValidatorAllTests.suite());
		suite.addTest(new TestSuite(TestUtilsTest.class));
		return suite;
	}
	
	public static void main(String[] args){
		junit.textui.TestRunner.run(suite());
	}
}
