/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.text.Format;
import java.util.Locale;

import woolpack.text.FormatFactory;
import woolpack.utils.Switchable;

/**
 * 現在のスレッドの{@link Locale}で{@link FormatFactory}を分岐する{@link FormatFactory}。
 * @author nakamura
 *
 */
public class LocaleFormatFactory implements FormatFactory {
	private final Switchable<Locale,FormatFactory> switchable;
	private final ThreadLocal<Locale> threadLocal;
	
	/**
	 * コンストラクタ。
	 * @param switchable {@link Locale}と委譲先の{@link Switchable}。
	 * @param threadLocal 現在のスレッドの{@link Locale}を保持する{@link ThreadLocal}。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public LocaleFormatFactory(final Switchable<Locale,FormatFactory> switchable, final ThreadLocal<Locale> threadLocal){
		switchable.getClass();
		threadLocal.getClass();
		
		this.switchable = switchable;
		this.threadLocal = threadLocal;
	}

	/**
	 * @throws NullPointerException ロケールに対する{@link FormatFactory}が存在しない場合。
	 */
	public Format newInstance() {
		return switchable.get(threadLocal.get()).newInstance();
	}
}
