/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.lang.reflect.Array;
import java.util.Collection;

import woolpack.utils.UtilsConstants;

/**
 * 一覧型のコンバータ。
 * @author nakamura
 *
 */
public class CollectionTypeConverter implements TypeConverter{
	private final TypeConverter converter;
	
	/**
	 * コンストラクタ。
	 * @param converter 委譲先。単純型のコンバートするために使用する。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public CollectionTypeConverter(final TypeConverter converter){
		converter.getClass();
		this.converter = converter;
	}

	public Object convert(final String propertyName, final Object beforeValue, final Class toType) {
		// TODO 変換ルールを再検討する
		if(Object.class.equals(toType)){
			return beforeValue;
		}
		final Collection collection = UtilsConstants.toCollection(beforeValue);
		if(toType.isArray()){
			// TODO 変換元が配列であっても新しい配列が作成されるので、再検討する。
			final Object afterArray = Array.newInstance(toType.getComponentType(), collection.size());
			int i=0;
			for(final Object before:collection){
				final Object after = converter.convert(propertyName, before, toType.getComponentType());
				Array.set(afterArray, i, after);
				i++;
			}
			return afterArray;
		}else if(Collection.class.isAssignableFrom(toType)){
			return collection;
		}else{
			final Object value = collection.iterator().next();
			if(value != null){
				return converter.convert(propertyName, value, toType);
			}else{
				return value;
			}
		}
	}
}
