/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * @author nakamura
 *
 */
public class UtilsAllTests extends TestCase {

	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(AppendableWriterTest.class));
		suite.addTest(new TestSuite(BranchInputStreamFactoryTest.class));
		suite.addTest(new TestSuite(DelegationCollectionTest.class));
		suite.addTest(new TestSuite(DelegationMapTest.class));
		suite.addTest(new TestSuite(DelegationSetTest.class));
		suite.addTest(new TestSuite(EmbeddingResolverTest.class));
		suite.addTest(new TestSuite(InputStreamReaderFactoryTest.class));
		suite.addTest(new TestSuite(IOExceptionReaderFactoryTest.class));
		suite.addTest(new TestSuite(KeyIteratorMapTest.class));
		suite.addTest(new TestSuite(MapIterableMapTest.class));
		suite.addTest(new TestSuite(StringReaderFactoryTest.class));
		suite.addTest(new TestSuite(StringInputStreamFactoryTest.class));
		suite.addTest(new TestSuite(UtilsConstantsTest.class));
		suite.addTest(new TestSuite(OGETest.class));
		suite.addTest(new TestSuite(PropertyUtilsTest.class));
		suite.addTest(new TestSuite(XPathWrapperTest.class));
		return suite;
	}
}
