/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.Arrays;
import java.util.Locale;

import junit.framework.TestCase;

public class LocaleConstantsTest extends TestCase {

	public void testSearch(){
		assertEquals(Locale.JAPANESE, LocaleConstants.search(Arrays.asList(Locale.ENGLISH, null, Locale.JAPANESE), Locale.JAPANESE));
		assertEquals(Locale.JAPANESE, LocaleConstants.search(Arrays.asList(Locale.ENGLISH, null, Locale.JAPANESE), Locale.JAPAN));
		assertEquals(Locale.JAPAN, LocaleConstants.search(Arrays.asList(Locale.US, null, Locale.JAPAN), Locale.JAPANESE));
		assertEquals(Locale.JAPAN, LocaleConstants.search(Arrays.asList(Locale.US, null, Locale.JAPAN), Locale.JAPAN));
		assertEquals(Locale.ENGLISH, LocaleConstants.search(Arrays.asList(Locale.ENGLISH, null), Locale.JAPANESE));
		assertEquals(null, LocaleConstants.search(Arrays.asList(null, Locale.ENGLISH), Locale.JAPANESE));
		assertEquals(Locale.JAPANESE, LocaleConstants.search(Arrays.asList(Locale.JAPANESE, Locale.ENGLISH), null));
		assertEquals(new Locale("ja", "JP", "POSIX"), LocaleConstants.search(Arrays.asList(Locale.JAPANESE, new Locale("ja", "JP", "POSIX")), Locale.JAPAN));
	}
}
