/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;
import woolpack.dom.XPath;
import woolpack.dom.XPathAttrValue;
import woolpack.utils.OGE;

public class MakeRadioTest extends TestCase {

	public void testConstructor(){
		try{
			new MakeRadio(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<SPAN>" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
						"</SPAN>"),
				new XPathAttrValue("name", "name1", new MakeRadio(new OGE("local.map0"))));
		final DomContext context = new DomContext();
		new OGE("local.map0 = #@java.util.LinkedHashMap@{\"v0\":\"l0\", \"v1\":\"l1\"}").getValue(context);
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<SPAN>" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v0\" />l0" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v1\" />l1" +
				"</SPAN>"));
	}
	
	public void testNotFound(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<SPAN>" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
						"</SPAN>"),
				new XPathAttrValue("name", "name1", new MakeRadio(new OGE("local.map0"))));
		final DomContext context = new DomContext();
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<SPAN>" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
				"</SPAN>"));
	}
	
	public void testTipsAuto(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<SPAN>" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value_a\" />label_a" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value_b\" />label_b" +
						"</SPAN>"),
				new XPath(
						"//INPUT[@type=\"radio\" or @type=\"checkbox\"]", 
						new MakeRadio(new OGE("local[node.getAttribute(\"name\")]")), 
						HtmlConstants.REMOVE_THIS_AND_TEXTS));
		final DomContext context = new DomContext();
		new OGE("local.name1 = #@java.util.LinkedHashMap@{\"v0\":\"l0\", \"v1\":\"l1\"}").getValue(context);
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<SPAN>" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v0\" />l0" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v1\" />l1" +
				"</SPAN>"));
	}
}
