/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Arrays;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.html.AutoUpdate;
import woolpack.utils.OGE;

public class LoopTest extends TestCase {

	public void testConstructor(){
		try{
			new Loop(null, OGE.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new Loop(OGE.NULL, null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new Loop(OGE.NULL, OGE.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testCollection(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<TABLE><TR id=\"iterate0\">" +
						"<TD><SPAN id=\"name0\">value0</SPAN></TD>" +
						"<TD><INPUT name=\"name1\" value=\"value1\" /></TD>" +
						"</TR></TABLE>"),
				new XPathAttrValue("id", "iterate0", new Loop(
						new OGE("local.list0"), 
						new OGE("local.bean"), 
						new AutoUpdate(Arrays.asList("name", "id"), new OGE("local.bean")))));
		
		final DomContext context = new DomContext();
		new OGE("local.list0 = {#{\"name0\":\"embed00\",  \"name1\":\"embed01\"}, #{\"name0\":\"embed10\",  \"name1\":\"embed11\"}}").getValue(context);
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<TABLE>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed00</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed01\" /></TD>" +
				"</TR>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed10</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed11\" /></TD>" +
				"</TR>" +
				"</TABLE>"));
	}
	
	public void testArray(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<TABLE><TR id=\"iterate0\">" +
						"<TD><SPAN id=\"name0\">value0</SPAN></TD>" +
						"<TD><INPUT name=\"name1\" value=\"value1\" /></TD>" +
						"</TR></TABLE>"),
				new XPathAttrValue("id", "iterate0", new Loop(
						new OGE("local.list0"), 
						new OGE("local.bean"), 
						new AutoUpdate(Arrays.asList("name", "id"), new OGE("local.bean")))));
		
		final DomContext context = new DomContext();
		new OGE("local.list0 = {#{\"name0\":\"embed00\",  \"name1\":\"embed01\"}, #{\"name0\":\"embed10\",  \"name1\":\"embed11\"}}").getValue(context);
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<TABLE>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed00</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed01\" /></TD>" +
				"</TR>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed10</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed11\" /></TD>" +
				"</TR>" +
				"</TABLE>"));
	}
}
