/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.utils.OGE;

public class EqualsAttrValueTest extends TestCase {

	public void testConstructor(){
		try{
			new EqualsAttrValue(null, OGE.NULL, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new EqualsAttrValue("", OGE.NULL, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new EqualsAttrValue("a", null, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new EqualsAttrValue("a", OGE.NULL, null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new EqualsAttrValue("a", OGE.NULL, DomConstants.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testTrueExpression(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
					"<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
			new XPathAttrValue("name", "name0", new EqualsAttrValue("value", new OGE("\"value0\""), 
					new UpdateAttrValue("value", new OGE("\"newValue1\"")), new UpdateAttrValue("value", new OGE("\"newValue2\"")))));
		final DomContext context = new DomContext();
		expression.interpret(context);
		
		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"newValue1\" />"));
	}
	
	public void testFalseExpression(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
			new XPathAttrValue("name", "name0", new EqualsAttrValue("value", new OGE("\"value1\""), 
					new UpdateAttrValue("value", new OGE("\"newValue1\"")), new UpdateAttrValue("value", new OGE("\"newValue2\"")))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"newValue2\" />"));
	}
	
	public void testNotFalseExpression(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
			new XPathAttrValue("name", "name0", new EqualsAttrValue("value", new OGE("\"value1\""), 
					new UpdateAttrValue("value", new OGE("\"newValue1\"")))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"));
	}
}
