/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;

import junit.framework.TestCase;
import woolpack.TestUtils;

public class DomConstantsTest extends TestCase {

	public void testNull(){
		final DomContext context = new DomContext();
		DomConstants.NULL.interpret(context);
	}

	public void testRemove(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody("<SPAN id=\"id0\" >value0</span>"),
				new XPathAttrValue("id", "id0", DomConstants.REMOVE_THIS));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsBody(context, ""));
	}
	
	public void testRemoveChildren(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody("<SPAN id=\"id0\" >value0</span>"),
				new XPathAttrValue("id", "id0", DomConstants.REMOVE_CHILDREN));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsBody(context, "<SPAN id=\"id0\" />"));
	}
	
	public void testRetainChildren(){
		final DomExpression expression = new Serial(Arrays.asList(
				TestUtils.getToNodeBody(
						"<SPAN id=\"id0\" >hoge0<SPAN id=\"id1\" >hoge1<SPAN id=\"id2\" >value0</span>piyo1</span>piyo0</span>"),
				new XPathAttrValue("id", "id1", DomConstants.RETAIN_CHILDREN)));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equals(context, "<SPAN id=\"id0\" >hoge0hoge1<SPAN id=\"id2\" >value0</span>piyo1piyo0</span>"));
	}
	
	public void testGetDocumentNode(){
		final DomExpression expression = 
			TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />");
		final DomContext context = new DomContext();
		expression.interpret(context);
		assertEquals(context.getNode(), DomConstants.getDocumentNode(context.getNode()));
		assertEquals(context.getNode(), DomConstants.getDocumentNode(context.getNode().getFirstChild()));
	}

	public void testWrite(){
		final DomExpression expression = 
			TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />");
		final DomContext context = new DomContext();
		expression.interpret(context);
		
		final StringWriter w = new StringWriter();
		DomConstants.write(context.getNode(), w);
		assertEquals("<HTML>\n<BODY>\n<FORM>\n<INPUT name=\"name0\" type=\"text\" value=\"value0\">\n</FORM>\n</BODY>\n</HTML>\n", w.toString());
	}
	
	public void testClearSession(){
		final DomContext context = new DomContext();
		context.setSession(new HashMap<String,Object>());
		context.getSession().put("key0", "value0");
		context.getSession().put("key1", "value1");
		assertFalse(context.getSession().isEmpty());
		DomConstants.CLEAR_SESSION.interpret(context);
		assertTrue(context.getSession().isEmpty());
	}
}
