/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.utils.OGE;

public class CacheNodeTest extends TestCase {

	public void testConstructor(){
		try{
			new CacheNode(0, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testCacheOn(){
		final Map<String,DomExpression> map = new HashMap<String,DomExpression>();
		map.put("id0", TestUtils.getToNodeBody("hoge0"));
		map.put("id1", TestUtils.getToNodeBody("hoge1"));
		map.put("id2", TestUtils.getToNodeBody("hoge2"));
		final Count counter0 = new Count(new Serial(
						new BranchById(map), 
						new XPath("//BODY", new ReplaceTextToChild(new OGE("\"piyo\"")))
				));
		final DomExpression expression = new CacheNode(Integer.MAX_VALUE, counter0);
		
		{
			final DomContext context = new DomContext();
			context.setId("id0");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(1, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id1");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(2, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id2");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(3, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		
		{
			final DomContext context = new DomContext();
			context.setId("id0");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(3, counter0.getCount());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id1");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(3, counter0.getCount());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id2");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(3, counter0.getCount());
		}
	}
	
	public void testCacheOff(){
		final Map<String,DomExpression> map = new HashMap<String,DomExpression>();
		map.put("id0", TestUtils.getToNodeBody("hoge0"));
		map.put("id1", TestUtils.getToNodeBody("hoge1"));
		map.put("id2", TestUtils.getToNodeBody("hoge2"));
		final Count counter0 = new Count(new Serial(
				new BranchById(map), 
				new XPath("//BODY", new ReplaceTextToChild(new OGE("\"piyo\"")))
				));
		final DomExpression expression = new CacheNode(0, counter0);
		
		{
			final DomContext context = new DomContext();
			context.setId("id0");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(1, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id1");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(2, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id2");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(3, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		
		{
			final DomContext context = new DomContext();
			context.setId("id0");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(4, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id1");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(5, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
		{
			final DomContext context = new DomContext();
			context.setId("id2");
			expression.interpret(context);

			assertTrue(TestUtils.equalsBody(context, "piyo"));
			assertEquals(6, counter0.getCount());
			assertTrue(context == counter0.getContextList().getLast());
		}
	}
}
