/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.utils.OGE;

public class BranchByNodeNameTest extends TestCase {

	public void testConstructor(){
		try{
			new BranchByNodeName(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal(){
		final Map<String,DomExpression> branch = new HashMap<String,DomExpression>();
		branch.put("TEXTAREA", new UpdateAttrValue("name", new OGE("\"newName0\"")));
		branch.put("INPUT", new UpdateAttrValue("name", new OGE("\"newName1\"")));
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody(
						"<TEXTAREA name=\"name0\" ></TEXTAREA>"+
						"<INPUT name=\"name1\" />"+
						"<SELECT name=\"name2\" ><OPTION value=\"0\"/>zero</SELECT>"),
				new XPath("//*[@name]", new BranchByNodeName(branch))
		);
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equals(context, 
				"<TEXTAREA name=\"newName0\" ></TEXTAREA>"+
				"<INPUT name=\"newName1\" />"+
				"<SELECT name=\"name2\" ><OPTION value=\"0\"/>zero</SELECT>"));
	}

	public void testNotOther(){
		final Map<String,DomExpression> branch = new HashMap<String,DomExpression>();
		branch.put("TEXTAREA", new UpdateAttrValue("name", new OGE("\"newName0\"")));
		branch.put("INPUT", new UpdateAttrValue("name", new OGE("\"newName1\"")));
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody(
						"<TEXTAREA name=\"name0\" ></TEXTAREA>"+
						"<INPUT name=\"name1\" />"+
						"<SELECT name=\"name2\" ><OPTION value=\"0\"/>zero</SELECT>"),
				new XPath("//*[@name]", new BranchByNodeName(branch))
		);
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equals(context, 
				"<TEXTAREA name=\"newName0\" ></TEXTAREA>"+
				"<INPUT name=\"newName1\" />"+
				"<SELECT name=\"name2\" ><OPTION value=\"0\"/>zero</SELECT>"));
	}
}
