/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.utils.MapBuilder;
import woolpack.utils.OGE;

public class BranchByIdTest extends TestCase {

	private DomExpression expression;
	
	@Override protected void setUp() throws Exception {
		super.setUp();
		expression = new Serial(
				TestUtils.getToNodeForm("<INPUT name=\"name0\" value=\"value0\" />"),
				new BranchById(new MapBuilder<String,DomExpression>()
						.put("id0", new XPathAttrValue("name", "name0", new UpdateAttrValue("value", new OGE("\"newValue0\""))))
						.put("id1", new XPathAttrValue("name", "name0", new UpdateAttrValue("value", new OGE("\"newValue1\""))))
						.put("id2", new XPathAttrValue("name", "name0", new UpdateAttrValue("value", new OGE("\"newValue2\""))))
						.getMap()));
	}

	public void testConstructor(){
		try{
			new BranchById(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal0(){
		final DomContext context = new DomContext();
		context.setId("id0");
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<INPUT name=\"name0\" value=\"newValue0\" />"));
	}

	public void testNormal1(){
		final DomContext context = new DomContext();
		context.setId("id1");
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<INPUT name=\"name0\" value=\"newValue1\" />"));
	}

	public void testNormal2(){
		final DomContext context = new DomContext();
		context.setId("id2");
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<INPUT name=\"name0\" value=\"newValue2\" />"));
	}

	public void testOther(){
		final DomContext context = new DomContext();
		context.setId("idE");
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<INPUT name=\"name0\" value=\"value0\" />"));
	}
}
