/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.LinkedList;

import junit.framework.TestCase;

public class ConfigCountTest extends TestCase {

	public void testConstructor(){
		try{
			new ConfigCount(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testCount(){
		final ConfigCount counter1 = new ConfigCount(ConfigConstants.NULL);
		final ConfigCount counter0 = new ConfigCount(counter1);
		final LinkedList<ConfigContext> expectedList = new LinkedList<ConfigContext>();
		assertEquals(0, counter1.getCount());
		assertEquals(0, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());

		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		assertEquals(1, counter1.getCount());
		assertEquals(1, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());
		
		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		assertEquals(2, counter1.getCount());
		assertEquals(2, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());
	}

	public void testZero(){
		final ConfigCount counter0 = new ConfigCount(0, ConfigConstants.NULL);
		final LinkedList<ConfigContext> expectedList = new LinkedList<ConfigContext>();
		assertEquals(0, counter0.getContextList().size());

		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		assertEquals(0, counter0.getContextList().size());
		
		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		assertEquals(0, counter0.getContextList().size());
	}

	public void testMax(){
		final ConfigCount counter0 = new ConfigCount(4, ConfigConstants.NULL);
		final LinkedList<ConfigContext> expectedList = new LinkedList<ConfigContext>();

		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		assertEquals(expectedList, counter0.getContextList());
		
		expectedList.add(new ConfigContext());
		counter0.interpret(expectedList.getLast());
		expectedList.removeFirst();
		assertEquals(expectedList, counter0.getContextList());
	}
}
