/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

/**
 * 文字列と{@link ValidatorExpression}の{@link Map}をプロパティとして持つ{@link ValidatorExpression}。
 * @author nakamura
 *
 */
abstract public class BranchValidator extends ValidatorExpressionAdapter{
	private final Map<String,ValidatorExpression> map;
	
	/**
	 * コンストラクタ。
	 * @param map 文字列と{@link ValidatorExpression}の{@link Map}。ステートレスであるべき。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public BranchValidator(final Map<String,ValidatorExpression> map){
		map.getClass();
		this.map = map;
	}

	/**
	 * サブクラスで実装する。
	 */
	@Override abstract public boolean interpret(final ValidatorContext context);
	
	/**
	 * 文字列と{@link ValidatorExpression}の{@link Map}を返す。
	 * @return 文字列と{@link ValidatorExpression}の{@link Map}。
	 */
	protected Map<String,ValidatorExpression> getMap(){
		return map;
	}
	
	@Override public void appendArgumentTo(final Appendable sb) throws IOException{
		ValidatorConstants.appendTo(sb, map);
	}

	@Override public void addMessageTo(final Collection<String> messageCollection) {
		for(final String key:map.keySet()){
			final ValidatorExpression expression = map.get(key);
			expression.addMessageTo(messageCollection);
		}
	}
}
