/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;
import java.io.Reader;

/**
 * {@link Reader}の生成器。
 * @author nakamura
 *
 */
public interface ReaderFactory {
	/**
	 * {@link Reader}を生成して返す。
	 * @param id キー。
	 * @return {@link Reader}。
	 * @throws IOException {@link Reader}の生成に失敗した場合。
	 */
	public Reader newInstance(String id) throws IOException;
}
