/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;

/**
 * 文字列をを解析して{@link java.sql.Date}に変換する変換器。
 * @author nakamura
 *
 */
public class ToSQLDateFormat extends DelegateDateFormat {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * コピーコンストラクタ。
	 * {@link #clone()}から呼び出される(called)。
	 * @param format コピー元。
	 * @param dummy ダミー。
	 */
	protected ToSQLDateFormat(final ToSQLDateFormat format, final boolean dummy) {
		super(format, dummy);
	}

	/**
	 * コンストラクタ。
	 * @param format 日付変換の委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ToSQLDateFormat(final DateFormat format) {
		super(format);
	}

	@Override
	public Date parse(String source, ParsePosition pos) {
		final Date d = super.parse(source, pos);
		if(d != null){
			return new java.sql.Date(d.getTime());
		}
		return null;
	}
	
	@Override public Object clone(){
		return new ToSQLDateFormat(this, false);
	}
}
