/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;


import woolpack.utils.OGE;

/**
 * 指定された DOM ノードの子ノードをテキストノードに置き換える{@link DomExpression}。
 * @author nakamura
 *
 */
public class ReplaceTextToChild implements DomExpression {
	private final OGE valueOGE;
	
	/**
	 * コンストラクタ。
	 * @param valueOGE 置き換える文字列の取得先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ReplaceTextToChild(final OGE valueOGE){
		valueOGE.getClass();
		this.valueOGE = valueOGE;
	}

	/**
	 * @throws NullPointerException 引数または{@link DomContext#getNode()}または取得した文字列が null の場合。
	 */
	public void interpret(final DomContext context) {
		final String value = valueOGE.getString(context);
		if(value != null){
			DomConstants.removeChildren(context.getNode());
			DomConstants.appendText(context.getNode(), value);
		}
	}
}
