/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

/**
 * メソッドの実行結果の受け入れ可否を拡張するために使用するマッチ操作。
 * @author nakamura
 *
 */
public interface ForwardMatchable {
	/**
	 * {@link ActionInvoker#findId(Iterable, Object)}から呼び出される(called)。
	 * マッチ操作を行う。
	 * @param aReturnedObject メソッドが返却したオブジェクト。
	 * @return マッチするなら true。それ以外は false。
	 */
	public boolean matches(Object aReturnedObject);
}
