/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.utils.UtilsConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;
import woolpack.validator.ValidatorIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorConstants {
    private static final Pattern LOCAL_CLASS_NAME = Pattern.compile("([^\\.]+\\.)*([^\\.]*)");
    public static final ValidatorExpression TRUE = new ValidatorExpression(){

        @Override
        public boolean interpret(ValidatorContext context) {
            return true;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new TrueValidator()");
        }

        @Override
        public void addMessageTo(Collection<String> messageCollection) {
        }
    };
    public static final ValidatorExpression FALSE = new ValidatorExpression(){

        @Override
        public boolean interpret(ValidatorContext context) {
            return false;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new FalseValidator()");
        }

        @Override
        public void addMessageTo(Collection<String> messageCollection) {
        }
    };
    public static final ValidatorExpression REQUIRED = new ValidatorExpression(){

        @Override
        public boolean interpret(ValidatorContext context) {
            Object value = context.getTmpValue();
            return value != null && (!(value instanceof String) || ((String)value).length() > 0);
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new RequiredValidator()");
        }

        @Override
        public void addMessageTo(Collection<String> messageCollection) {
        }
    };
    public static final ValidatorIterable OR = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean result = false;
            boolean empty = true;
            for (ValidatorExpression validatorExpression : iterable) {
                empty = false;
                result |= validatorExpression.interpret(context);
            }
            return result || empty;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new OrValidatorIterable()");
        }
    };
    public static final ValidatorIterable OROR = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean empty = true;
            for (ValidatorExpression validatorExpression : iterable) {
                empty = false;
                if (!validatorExpression.interpret(context)) continue;
                return true;
            }
            return empty;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new OrOrValidatorIterable()");
        }
    };
    public static final ValidatorIterable AND = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean flag = true;
            for (ValidatorExpression validatorExpression : iterable) {
                flag &= validatorExpression.interpret(context);
            }
            return flag;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new AndValidatorIterable()");
        }
    };
    public static final ValidatorIterable ANDAND = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            for (ValidatorExpression validatorExpression : iterable) {
                boolean flag = validatorExpression.interpret(context);
                if (flag) continue;
                return false;
            }
            return true;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new AndAndValidatorIterable()");
        }
    };
    public static final ValidatorIterable EQ = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean trueFlag = true;
            boolean falseFlag = true;
            for (ValidatorExpression validatorExpression : iterable) {
                boolean flag = validatorExpression.interpret(context);
                trueFlag &= flag;
                falseFlag &= !flag;
            }
            return trueFlag || falseFlag;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new EqValidatorIterable()");
        }
    };
    public static final ValidatorIterable EQEQ = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean trueFlag = true;
            boolean falseFlag = true;
            for (ValidatorExpression validatorExpression : iterable) {
                boolean flag = validatorExpression.interpret(context);
                if ((trueFlag &= flag) || (falseFlag &= !flag)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append("new EqEqValidatorIterable()");
        }
    };

    private ValidatorConstants() {
    }

    public static String getLocalClassName(Class clazz) {
        Matcher m = LOCAL_CLASS_NAME.matcher(clazz.getName());
        m.matches();
        return m.group(2);
    }

    public static Map<String, List<Object>> convert(Map map) {
        HashMap<String, List<Object>> map1 = new HashMap<String, List<Object>>();
        for (Object key : map.keySet()) {
            Iterable c = UtilsConstants.toIterable(map.get(key));
            ArrayList list = new ArrayList();
            for (Object o : c) {
                list.add(o);
            }
            map1.put((String)key, list);
        }
        return map1;
    }

    public static void appendTo(Appendable sb, Iterable<String> iterable) throws IOException {
        sb.append('[');
        boolean flag = true;
        for (String v : iterable) {
            if (!flag) {
                sb.append(',');
            }
            flag = false;
            ValidatorConstants.appendTo(sb, v);
        }
        sb.append(']');
    }

    public static void appendTo(Appendable sb, Pattern pattern) throws IOException {
        ValidatorConstants.appendTo(sb, pattern.pattern());
    }

    public static void appendTo(Appendable sb, Map<? extends Object, ValidatorExpression> map) throws IOException {
        sb.append('{');
        boolean flag = false;
        for (Object object : map.keySet()) {
            if (flag) {
                sb.append(',');
            }
            flag = true;
            ValidatorExpression expression = map.get(object);
            ValidatorConstants.appendTo(sb, object.toString());
            sb.append(':');
            expression.appendTo(sb);
        }
        sb.append('}');
    }

    public static void appendTo(Appendable sb, String s) throws IOException {
        sb.append('\"');
        sb.append(s);
        sb.append('\"');
    }
}

