/*
 * Decompiled with CFR 0.152.
 */
package woolpack.container;

import java.util.HashMap;
import java.util.Map;
import woolpack.container.ComponentScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentDef {
    private final ComponentScope scope;
    private final Object singletonValue;

    public ComponentDef(ComponentScope scope) {
        ((Object)((Object)scope)).getClass();
        this.scope = scope;
        this.singletonValue = scope == ComponentScope.SINGLETON ? this.newInstance() : null;
    }

    Object getComponent(String attrName, String key, Map<String, Object> request, Map<String, Object> session, Map<String, Object> application) {
        if (this.scope == ComponentScope.SINGLETON) {
            return this.singletonValue;
        }
        if (this.scope == ComponentScope.REQUEST) {
            return this.getComponent(attrName, key, request);
        }
        if (this.scope == ComponentScope.SESSION) {
            return this.getComponent(attrName, key, session);
        }
        if (this.scope == ComponentScope.APPLICATION) {
            return this.getComponent(attrName, key, application);
        }
        return this.newInstance();
    }

    private synchronized Object getComponent(String attrName, String key, Map<String, Object> map) {
        Object result;
        HashMap container = (HashMap)map.get(attrName);
        if (container == null) {
            container = new HashMap();
            map.put(attrName, container);
        }
        if ((result = container.get(key)) == null) {
            result = this.newInstance();
            container.put(key, result);
        }
        return result;
    }

    protected abstract Object newInstance();
}

