'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  IWomenWCSearchEngine.vb                                 --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.Interfaces.SearchEngine                     --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Infos.SearchEngine
Imports WomenWCCore.Document
Namespace Interfaces.SearchEngine
    Public Interface IWomenWCSearchEngine

        Function GetAllFindString(ByVal documentList As List(Of Document.Document), _
                                  ByVal findString As String, _
                                  ByVal matchCase As Boolean, _
                                  ByVal matchWord As Boolean) As List(Of FindResultInfo)

        Function GetNextFindString(ByVal document As Document.Document, _
                                   ByVal findstring As String, _
                                   ByVal currentRow As Integer, _
                                   ByVal currentCol As Integer, _
                                   ByVal matchCase As Boolean, _
                                   ByVal matchWord As Boolean, _
                                   ByVal upDirection As Boolean) As FindResultInfo

        Function GetNextBookMark(ByVal document As Document.Document, _
                                 ByVal currentRow As Integer, _
                                 ByVal upDirection As Boolean) As FindResultInfo

    End Interface
End Namespace
