'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  IWomenWCSyntax.vb                                       --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.Interfaces.Analyzer                         --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Infos.Analyzer

Namespace Interfaces.Analyzer

    Public Interface IWomenWCSyntax

        Sub GetMembers(ByVal document As Document.Document, _
                       ByRef functions As List(Of FunctionInfo), _
                       ByRef variables As List(Of VariableInfo), _
                       ByRef includes As List(Of IncludeInfo))

        Function GetSentence(ByVal document As Document.Document, ByVal startRow As Integer, ByVal startCol As Integer, Optional ByVal withSpaceAndComment As Boolean = False) As SentenceInfo

        Function GetFunction(ByVal sentenceInfo As SentenceInfo) As FunctionInfo

        Function GetVariable(ByVal sentenceInfo As SentenceInfo) As VariableInfo

        Function GetInclude(ByVal sentenceInfo As SentenceInfo) As IncludeInfo

        Function GetSentences(ByVal document As Document.Document, Optional ByVal withSpaceAndComment As Boolean = False) As List(Of SentenceInfo)

        Function GetFunctions(ByVal document As Document.Document) As List(Of FunctionInfo)

        Function GetVariables(ByVal document As Document.Document) As List(Of VariableInfo)

        Function GetIncludes(ByVal document As Document.Document) As List(Of IncludeInfo)

    End Interface

End Namespace
