'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  CaretStatusChangedEventArgs.vb                          --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.EventArgs                                   --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Enums

Namespace EventArgs
    Public Class CaretStatusChangedEventArgs
        Inherits System.EventArgs

        Private _caretStatus As CaretStatusEnum

        Public Sub New(ByVal caretStatus As CaretStatusEnum)
            _caretStatus = caretStatus
        End Sub

        Public ReadOnly Property CaretStatus() As CaretStatusEnum
            Get
                Return _caretStatus
            End Get
        End Property

    End Class
End Namespace
