'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  CobolEditAssistant.vb                                   --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCAnalyzer.Cobol                                   --
'--                                                                           --
'--  Project       :  WomenWCAnalyzer                                         --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Interfaces.Analyzer
Imports WomenWCCore.Infos.Analyzer
Imports WomenWCCore.Enums
Namespace Cobol
    Public Class CobolEditAssistant
        Implements IWomenWCEditAssistant

        Private Const COMMENT_SYMBOL As String = "*"

        Private _cobolLex As IWomenWCLex
        Private _cobolSyntax As IWomenWCSyntax

        Public Sub New(ByVal cobolLex As IWomenWCLex, ByVal cobolSyntax As IWomenWCSyntax)
            _cobolLex = cobolLex
            _cobolSyntax = cobolSyntax
        End Sub

        Public Function GetDefaultSplitLine() As List(Of Integer) Implements IWomenWCEditAssistant.GetDefaultSplitLine
            Dim result As New List(Of Integer)
            result.Add(6)
            result.Add(7)
            result.Add(72)
            Return result
        End Function

        Public Function GetLineHearder(ByVal prevParseString As String) As String Implements IWomenWCEditAssistant.GetLineHearder
            Dim result As String = String.Empty
            Dim prevParseWords As List(Of WordInfo)

            prevParseWords = _cobolLex.GetWords(prevParseString)

            If prevParseWords.Count = 1 Then
                result = String.Empty
            ElseIf prevParseWords.Count = 2 Then
                result = Space(6)
            ElseIf prevParseWords.Count > 2 Then
                If prevParseWords(2).WordType = WordTypeEnum.Space Then
                    result = Space(7 + prevParseWords(2).WordString.Length)
                Else
                    result = Space(7)
                End If
            Else
                result = String.Empty
            End If
            Return result
        End Function

        Public Function GetCommentString(ByVal parseString As String) As String Implements IWomenWCEditAssistant.GetCommentString
            Dim result As String

            If Common.StringTransaction.GetLengthByByte(parseString) < 7 Then
                result = parseString
            Else
                result = Common.StringTransaction.GetSubStringByByte(parseString, 0, 6) & _
                         COMMENT_SYMBOL & _
                         Common.StringTransaction.GetSubStringByByte(parseString, 7)
            End If
            Return result
        End Function

        Public Function GetUnCommentString(ByVal parseString As String) As String Implements IWomenWCEditAssistant.GetUnCommentString
            Dim result As String

            If Common.StringTransaction.GetLengthByByte(parseString) < 7 Then
                result = parseString
            Else
                result = Common.StringTransaction.GetSubStringByByte(parseString, 0, 6) & _
                         Space(1) & _
                         Common.StringTransaction.GetSubStringByByte(parseString, 7)
            End If
            Return result
        End Function

    End Class
End Namespace
