'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  CobolAnalyzer.vb                                        --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCAnalyzer.Cobol                                   --
'--                                                                           --
'--  Project       :  WomenWCAnalyzer                                         --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Interfaces.Analyzer
Namespace Cobol
    Public Class CobolAnalyzer
        Implements IWomenWCAnalyzer

        Private _cobolLex As CobolLex
        Private _cobolSyntax As CobolSyntax
        Private _cobolEditAssistant As CobolEditAssistant

        Public Sub New()
            _cobolLex = New CobolLex()
            _cobolSyntax = New CobolSyntax(_cobolLex)
            _cobolEditAssistant = New CobolEditAssistant(_cobolLex, _cobolSyntax)
        End Sub

        Public ReadOnly Property WomenWCLex() As IWomenWCLex Implements IWomenWCAnalyzer.WomenWCLex
            Get
                Return _cobolLex
            End Get
        End Property

        Public ReadOnly Property WomenWCSyntax() As IWomenWCSyntax Implements IWomenWCAnalyzer.WomenWCSyntax
            Get
                Return _cobolSyntax
            End Get
        End Property

        Public ReadOnly Property WomenWCEditAssistant() As IWomenWCEditAssistant Implements IWomenWCAnalyzer.WomenWCEditAssistant
            Get
                Return _cobolEditAssistant
            End Get
        End Property

    End Class
End Namespace
