'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OptionGeneralView.vb                                    --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Views                                           --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Infos.Setting
Imports WomenWC.Managers.Manager

Namespace Views
    Public Class OptionGeneralView

        Public Overrides Sub SetPartSettingInfo(ByRef settingInfo As SettingInfo)
            settingInfo.MaxRecentProjectCount = Me._numProjectFileCount.Value
            If settingInfo.RecentProjects.Count > settingInfo.MaxRecentProjectCount Then
                settingInfo.RecentProjects.RemoveRange(settingInfo.MaxRecentProjectCount, settingInfo.RecentProjects.Count - settingInfo.MaxRecentProjectCount)
            End If
            settingInfo.MaxRecentFileCount = Me._numFileCount.Value
            If settingInfo.RecentFiles.Count > settingInfo.MaxRecentFileCount Then
                settingInfo.RecentFiles.RemoveRange(settingInfo.MaxRecentFileCount, settingInfo.RecentFiles.Count - settingInfo.MaxRecentFileCount)
            End If
        End Sub

        Public Overrides Sub Initialize(ByVal settingInfo As SettingInfo)
            Me._numProjectFileCount.Value = settingInfo.MaxRecentProjectCount
            Me._numFileCount.Value = settingInfo.MaxRecentFileCount
        End Sub

    End Class
End Namespace
