'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  StartUp.vb                                              --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  My                                                      --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Threading
Imports System.Xml
Imports WomenWC.Managers
Imports WomenWC.Managers.Manager
Imports WomenWC.Forms
Imports Common

Namespace My

    Partial Friend Class MyApplication

        Private Const STATUS_SETTING As String = "ݒ[hĂ܂..."
        Private Const STATUS_ANALYZER As String = "AiCU[hĂ܂..."
        Private Const STATUS_EDITOR As String = "GfB^[[hĂ܂..."
        Private Const STATUS_SEARCHENGINE As String = "GW[hĂ܂..."

        Private Sub MyApplication_Startup(ByVal sender As Object, ByVal e As Microsoft.VisualBasic.ApplicationServices.StartupEventArgs) Handles Me.Startup
            Dim splashScreen As New SplashScreenForm
            Dim xmlDoc As XmlDocument

            Try
                splashScreen.Show()

                If IO.File.Exists(My.Resources.SettingFileName) Then
                    splashScreen.Status = STATUS_SETTING
                    SettingManager.LoadFromXML(My.Resources.SettingFileName)
                Else
                    Common.Message.ShowMessage(My.Resources.WWC002_001_I, My.Resources.SettingFileName)
                End If


                If IO.File.Exists(My.Resources.ComponentFileName) Then
                    xmlDoc = New XmlDocument()
                    xmlDoc.Load(My.Resources.ComponentFileName)

                    splashScreen.Status = STATUS_ANALYZER
                    AnalyzerManager.CreateAnalyzers(xmlDoc)

                    splashScreen.Status = STATUS_EDITOR
                    EditorManager.CreateEditorType(xmlDoc)

                    splashScreen.Status = STATUS_SEARCHENGINE
                    SearchManager.CreateSearchEngine(xmlDoc)
                Else
                    Throw New MyException(My.Resources.WWC002_002_C, My.Resources.ComponentFileName)
                End If

            Catch myex As MyException
                Common.Message.ShowMessage(myex)
                e.Cancel = True

            Catch ex As Exception
                Common.Message.ShowMessage(ex)
                e.Cancel = True

            Finally
                splashScreen.Close()
            End Try

        End Sub

        Private Sub MyApplication_Shutdown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shutdown
            Try
                SettingManager.SaveToXML(My.Resources.SettingFileName)

            Catch myex As MyException
                Common.Message.ShowMessage(myex)

            Catch ex As Exception
                Common.Message.ShowMessage(ex)
            End Try
        End Sub

    End Class

End Namespace

