'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnRevertWindow.vb                                       --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Window                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.Window

    Public Class OnRevertWindow
        Inherits Menu.MenuItemProcessBase

        Private Const STR_COMMENT As String = "SẴEBhẼTCYɖ߂"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.DocumentForms.Count > 0 Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            For Each docForm As DocumentForm In DocumentFormManager.DocumentForms
                docForm.WindowState = FormWindowState.Normal
            Next
            Me.WomenWCMainForm.LayoutMdi(MdiLayout.Cascade)
        End Sub

    End Class
End Namespace
