'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnPrevFind.vb                                           --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Search                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager
Imports WomenWCCore.Document
Imports WomenWCCore.Infos.SearchEngine

Namespace Menu.Search
    Public Class OnPrevFind
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "O"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.CurrentDocumentForm IsNot Nothing AndAlso _
                               SearchManager.HasFindHistory Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            SearchManager.FindDialog.FindPrev()
        End Sub

    End Class
End Namespace