'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnDeleteFile.vb                                         --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Project                                    --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWCCore.Infos.Analyzer
Imports WomenWCCore.Document
Imports WomenWCCore.Interfaces.Info
Imports WomenWC.Managers.Manager

Namespace Menu.Project
    Public Class OnDeleteFile
        Inherits Menu.MenuItemProcessBase

        Private Const STR_COMMENT As String = "w̃t@CvWFNg폜"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If WomenWCMainForm._projectView._projectTreeView.SelectedNode IsNot Nothing _
                  AndAlso TypeOf (WomenWCMainForm._projectView._projectTreeView.SelectedNode.Tag) Is ProgramInfo Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            DeleteSelectedNode(ProjectTreeView.SelectedNode())
        End Sub

        Private ReadOnly Property ProjectTreeView() As TreeView
            Get
                Return WomenWCMainForm._projectView._projectTreeView
            End Get
        End Property

        Private Sub DeleteSelectedNode(ByVal selectedNode As TreeNode)
            Dim programFileName As String
            Dim docForm As DocumentForm
            programFileName = DirectCast(selectedNode.Tag, ProgramInfo).ProgramFileName
            docForm = DocumentFormManager.DocumentForms(programFileName)
            DocumentFormManager.RemoveDocumentForm(docForm)
            ProjectManager.RemoveProgramInfo(programFileName)
            DocumentManager.RemoveDocument(programFileName)
            ProjectTreeView.Nodes.Remove(selectedNode)
            MemberManager.DeleteMembers(programFileName)
            WomenWCMainForm._findResultView.ViewClear()
        End Sub

    End Class
End Namespace