'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  MenuItemProcessBase.vb                                  --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu                                            --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Interfaces.Menu
Imports WomenWCCore.Infos.Menu
Imports WomenWC.Forms

Namespace Menu
    Public MustInherit Class MenuItemProcessBase
        Implements IMenuItemProcess

        Private _womenWCMainForm As WomenWCMainForm

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            _womenWCMainForm = womenWCMainForm
        End Sub

        Public Overridable ReadOnly Property Comment() As String Implements IMenuItemProcess.Comment
            Get
                Return String.Empty
            End Get
        End Property

        Public Overridable ReadOnly Property IsEnable() As Boolean Implements IMenuItemProcess.IsEnable
            Get
                Return True
            End Get
        End Property

        Public Overridable ReadOnly Property HasDynamicMenuItem() As Boolean Implements IMenuItemProcess.HasDynamicMenuItem
            Get
                Return False
            End Get
        End Property

        Public Overridable ReadOnly Property DynamicMenuItemInfos() As List(Of DynamicMenuItemInfo) Implements IMenuItemProcess.DynamicMenuItemInfos
            Get
                Return Nothing
            End Get
        End Property

        Public MustOverride Sub Execute() Implements IMenuItemProcess.Execute

        Protected ReadOnly Property WomenWCMainForm() As WomenWCMainForm
            Get
                Return _womenWCMainForm
            End Get
        End Property

    End Class
End Namespace
