'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnTechnology.vb                                         --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Help                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Namespace Menu.Help
    Public Class OnTechnology
        Inherits MenuItemProcessBase

        Private Const TECH_FILENAME As String = "Documents\Technology.chm"
        Private Const STR_COMMENT As String = "wv\"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                Return IO.File.Exists(TECH_FILENAME)
            End Get
        End Property

        Public Overrides Sub Execute()
            If IO.File.Exists(TECH_FILENAME) Then
                System.Windows.Forms.Help.ShowHelp(WomenWCMainForm, TECH_FILENAME)
            Else
            End If
        End Sub

    End Class
End Namespace
