'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnRecentFileSubItem.vb                                  --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWCCore.Interfaces.Analyzer
Imports WomenWC.Managers.Manager
Imports Common

Namespace Menu.File
    Public Class OnRecentFileSubItem
        Inherits MenuItemProcessBase

        Private _fileName As String
        Private Const STR_COMMENT As String = "w̃t@CJ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm, ByVal projectName As String)
            MyBase.New(womenWCMainForm)
            _fileName = projectName
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim documentFileExtension As String
            Dim womenWCAnalyzerName As String
            Dim womenWCAnalyzer As IWomenWCAnalyzer

            If IO.File.Exists(_fileName) = True Then
                If DocumentFormManager.DocumentForms(_fileName) IsNot Nothing Then
                    DocumentFormManager.DocumentForms(_fileName).Activate()
                Else
                    documentFileExtension = IO.Path.GetExtension(_fileName).ToLower
                    womenWCAnalyzerName = SettingManager.SettingInfo.FileExtension(documentFileExtension)
                    If womenWCAnalyzerName IsNot Nothing Then
                        womenWCAnalyzer = AnalyzerManager.Analyzers(womenWCAnalyzerName)
                    Else
                        womenWCAnalyzer = Nothing
                    End If
                    OpenFile(_fileName, womenWCAnalyzer)
                End If
            Else
                Throw New MyException(My.Resources.WWC002_016_E, _fileName)
            End If
        End Sub

        Private Sub OpenFile(ByVal fileName As String, ByVal womenWCAnalyzer As IWomenWCAnalyzer)
            DocumentManager.AddDocument(fileName)
            DocumentFormManager.AddDocumentForm(DocumentManager.Documents(fileName), womenWCAnalyzer)
            DocumentFormManager.ActivateDocumentForm(fileName, FormWindowState.Maximized)
        End Sub
    End Class

End Namespace
