'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnOpenFile.vb                                           --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Dialogues
Imports WomenWC.Managers.Manager
Imports WomenWCCore.Interfaces.Analyzer

Namespace Menu.File
    Public Class OnOpenFile
        Inherits MenuItemProcessBase

        Private _openFileDialog As MyOpenFileDialog
        Private Const STR_COMMENT As String = "ۑĂt@CJ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
            _openFileDialog = New MyOpenFileDialog
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim documentFileName As String
            Dim documentFileExtension As String
            Dim womenWCAnalyzerName As String
            Dim womenWCAnalyzer As IWomenWCAnalyzer

            If _openFileDialog.ShowDialog = Windows.Forms.DialogResult.OK Then
                documentFileName = _openFileDialog.FileName
                documentFileExtension = IO.Path.GetExtension(documentFileName).ToLower
                womenWCAnalyzerName = SettingManager.SettingInfo.FileExtension(documentFileExtension)
                If womenWCAnalyzerName IsNot Nothing Then
                    womenWCAnalyzer = AnalyzerManager.Analyzers(womenWCAnalyzerName)
                Else
                    womenWCAnalyzer = Nothing
                End If
                OpenFile(documentFileName, womenWCAnalyzer)
            End If
        End Sub

        Private Sub OpenFile(ByVal fileName As String, ByVal womenWCAnalyzer As IWomenWCAnalyzer)
            DocumentManager.AddDocument(fileName)
            DocumentFormManager.AddDocumentForm(DocumentManager.Documents(fileName), womenWCAnalyzer)
            DocumentFormManager.ActivateDocumentForm(fileName, FormWindowState.Maximized)
            SettingManager.RefreshOpenFileHistory(fileName)
        End Sub

    End Class
End Namespace
