'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnNewProject.vb                                         --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager
Imports WomenWC.Menu
Imports WomenWC.Dialogues
Imports Common
Imports System.Xml
Imports System.Text

Namespace Menu.File
    Public Class OnNewProject
        Inherits MenuItemProcessBase

        Private _newProjectDialog As NewProjectDialog
        Private Const STR_COMMENT As String = "VKvWFNg̍쐬"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
            _newProjectDialog = New NewProjectDialog
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim projectFileName As String
            If _newProjectDialog.ShowDialog() = DialogResult.OK Then
                projectFileName = _newProjectDialog.ProjectFullName
                CreateNewProject(projectFileName)
            End If
        End Sub

        Private Sub CreateNewProject(ByVal projectFileName As String)
            DocumentFormManager.WindowCloseAll()
            DocumentManager.RemoveAllDocument()
            MemberManager.RemoveAllMember()
            ProjectManager.CreateProjectInfo(projectFileName)
            WomenWCMainForm._projectView.InitializeProjectTreeView()
        End Sub


    End Class
End Namespace
