'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnCloseProject.vb                                       --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWCCore
Imports WomenWC.Managers.Manager

Namespace Menu.File
    Public Class OnCloseProject
        Inherits Menu.MenuItemProcessBase

        Private Const STR_COMMENT As String = "ƒ̃vWFNg"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If ProjectManager.ProjectInfo IsNot Nothing Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            CloseDocumentForms()
            ProjectManager.SaveProject()
            DocumentFormManager.WindowCloseAll()
            MemberManager.RemoveAllMember()
            DocumentManager.RemoveAllDocument()
            ProjectManager.RemoveAllProgramInfo()
            WomenWCMainForm._projectView.ClearProjectTreeView()
            WomenWCMainForm._findResultView.ViewClear()
            WomenWCMainForm._projectView._propertyView.Rows.Clear()
        End Sub

        Private Sub CloseDocumentForms()
            For Each docForm As DocumentForm In DocumentFormManager.DocumentForms
                docForm.Close()
            Next
            DocumentFormManager.ClearGoToHistory()
        End Sub

    End Class
End Namespace
