'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnPaste.vb                                              --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Edit                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.Edit
    Public Class OnPaste
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "Nbv{[h̓eJ[\̈ʒuɓ\t"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                Dim result As Boolean
                Dim dataObject As DataObject
                Dim currentDocumentForm As DocumentForm

                currentDocumentForm = DocumentFormManager.CurrentDocumentForm()
                dataObject = DirectCast(Clipboard.GetDataObject(), DataObject)

                If currentDocumentForm IsNot Nothing AndAlso _
                   dataObject.GetDataPresent(System.Windows.Forms.DataFormats.Text) Then
                    result = True
                Else
                    result = False
                End If

                Return result

            End Get
        End Property

        Public Overrides Sub Execute()
            Dim currentDocumentForm As DocumentForm
            currentDocumentForm = DocumentFormManager.CurrentDocumentForm()

            If currentDocumentForm IsNot Nothing Then
                currentDocumentForm.WomenWCEditor.Paste()
            Else
            End If
        End Sub

    End Class
End Namespace