'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnCut.vb                                                --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Edit                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.Edit
    Public Class OnCut
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "Ie폜ăNbv{[hɕۑ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                Dim currentDocumentForm As DocumentForm
                Dim result As Boolean
                currentDocumentForm = DocumentFormManager.CurrentDocumentForm()

                If currentDocumentForm IsNot Nothing Then
                    result = currentDocumentForm.Document.Selection.Selected
                Else
                    result = False
                End If
                Return result
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim currentDocumentForm As DocumentForm
            currentDocumentForm = DocumentFormManager.CurrentDocumentForm()

            If currentDocumentForm IsNot Nothing Then
                currentDocumentForm.WomenWCEditor.Cut()
            Else
            End If
        End Sub

    End Class
End Namespace
