'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  SearchManagerSingleton.vb                               --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Managers                                        --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Interfaces.SearchEngine
Imports WomenWC.Forms
Imports WomenWC.Dialogues
Imports System.Windows.Forms
Imports System.Xml
Imports System.Reflection
Imports Common

Namespace Managers
    Public Class SearchManagerSingleton

        Private Const XML_SEARCHENGINEDEFINE_PATH As String = "WomenWCComponentDefines/WomenWCSearchEngineDefine"
        Private Const XML_CLASSNAME_ATTRIBUTE As String = "ClassName"
        Private Const XML_FILENAME_ATTRIBUTE As String = "FileName"

        Private Shared _searchManager As SearchManagerSingleton

        Private _womenWCSearchEngine As IWomenWCSearchEngine
        Private _findDialog As FindDialog

        Private Sub New()
            _womenWCSearchEngine = Nothing
            _findDialog = New FindDialog(WomenWCMainForm)
        End Sub

        Public Shared ReadOnly Property SearchManager() As SearchManagerSingleton
            Get
                If _searchManager Is Nothing Then
                    _searchManager = New SearchManagerSingleton
                End If
                Return _searchManager
            End Get
        End Property

        Public ReadOnly Property WomenWCSearchEngine() As IWomenWCSearchEngine
            Get
                Return _womenWCSearchEngine
            End Get
        End Property

        Public ReadOnly Property FindDialog() As FindDialog
            Get
                _findDialog.IsFind = True
                Return _findDialog
            End Get
        End Property

        Public ReadOnly Property ReplaceDialog() As FindDialog
            Get
                _findDialog.IsFind = False
                Return _findDialog
            End Get
        End Property

        Public ReadOnly Property HasFindHistory() As Boolean
            Get
                If _findDialog._cmbFindString.Items.Count > 0 Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Sub CreateSearchEngine(ByVal xmlDoc As XmlDocument)
            Dim searchEngineDefineNode As XmlNode
            Dim searchEngineClassName As String
            Dim searchEngineFileName As String
            Dim searchEngineType As Type

            Try
                searchEngineDefineNode = xmlDoc.SelectSingleNode(XML_SEARCHENGINEDEFINE_PATH)
                searchEngineClassName = searchEngineDefineNode.Attributes(XML_CLASSNAME_ATTRIBUTE).Value
                searchEngineFileName = IO.Path.Combine(Application.StartupPath, searchEngineDefineNode.Attributes(XML_FILENAME_ATTRIBUTE).Value)
                searchEngineType = Assembly.LoadFile(searchEngineFileName).GetType(searchEngineClassName)
                _womenWCSearchEngine = Activator.CreateInstance(searchEngineType)
            Catch ex As Exception
                Throw New MyException(My.Resources.WWC002_005_C, ex.Message)
            End Try
        End Sub
        
    End Class
End Namespace
