'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  EditorManagerSingleton.vb                               --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Managers                                        --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Interfaces.Editor
Imports WomenWCCore.Interfaces.Analyzer
Imports WomenWCCore.Document
Imports WomenWC.Managers.Manager
Imports System.Xml
Imports System.Reflection
Imports Common

Namespace Managers

    Public Class EditorManagerSingleton

        Private Const XML_EDITORDEFINE_PATH As String = "WomenWCComponentDefines/WomenWCEditorDefine"
        Private Const XML_CLASSNAME_ATTRIBUTE As String = "ClassName"
        Private Const XML_FILENAME_ATTRIBUTE As String = "FileName"

        Private Shared _editorManager As EditorManagerSingleton

        Private _womenWCEditorType As Type

        Private Sub New()
        End Sub

        Public Shared ReadOnly Property EditorManager() As EditorManagerSingleton
            Get
                If _editorManager Is Nothing Then
                    _editorManager = New EditorManagerSingleton
                End If
                Return _editorManager
            End Get
        End Property

        Public Sub CreateEditorType(ByVal xmlDoc As XmlDocument)
            Dim editorDefineNode As XmlNode
            Dim editorClassName As String
            Dim editorFileName As String
            Try
                editorDefineNode = xmlDoc.SelectSingleNode(XML_EDITORDEFINE_PATH)
                editorClassName = editorDefineNode.Attributes(XML_CLASSNAME_ATTRIBUTE).Value
                editorFileName = IO.Path.Combine(Application.StartupPath, editorDefineNode.Attributes(XML_FILENAME_ATTRIBUTE).Value)
                _womenWCEditorType = Assembly.LoadFile(editorFileName).GetType(editorClassName)
            Catch ex As Exception
                Throw New MyException(My.Resources.WWC002_004_C, ex.Message)
            End Try

        End Sub

        Public Function WomenWCEditorFactory(ByVal document As Document, ByVal womenWCAnalyzer As IWomenWCAnalyzer) As IWomenWCEditor
            Dim womenWCEditor As IWomenWCEditor
            If _womenWCEditorType IsNot Nothing Then
                womenWCEditor = Activator.CreateInstance(_womenWCEditorType)
                womenWCEditor.Font = New System.Drawing.Font("lr SVbN", 10.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(128, Byte))
                womenWCEditor.Initialize(document, womenWCAnalyzer, SettingManager.SettingInfo.FontColor)
            Else
                womenWCEditor = Nothing
            End If
            Return womenWCEditor
        End Function

    End Class
End Namespace
