'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  NewProjectDialog.vb                                     --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Dialogues                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Windows.Forms

Namespace Dialogues
    Public Class NewProjectDialog

        Private Const PROJECT_EXTEND = ".wwc"
        Private Const PROJECT_NONAME As String = "NoNameProject"

        Public ReadOnly Property ProjectFullName() As String
            Get
                Return IO.Path.Combine(_cmbProjectFolderName.Text.Trim, _txtProjectName.Text.Trim)
            End Get
        End Property

        Private Sub _btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _btnOK.Click
            Select Case InputCheck()
                Case 0
                    Me.DialogResult = System.Windows.Forms.DialogResult.OK
                    Me._cmbProjectFolderName.Items.Add(_folderBrowserDialog.SelectedPath())
                    Me.Close()
                Case 1
                    Me._txtProjectName.Focus()
                    Me._txtProjectName.SelectAll()
                    Common.Message.ShowMessage(My.Resources.WWC002_007_E)
                Case 2
                    Me._cmbProjectFolderName.Focus()
                    Me._cmbProjectFolderName.SelectAll()
                    Common.Message.ShowMessage(My.Resources.WWC002_008_E)
                Case 3
                    Me._cmbProjectFolderName.Focus()
                    Me._cmbProjectFolderName.SelectAll()
                    Common.Message.ShowMessage(My.Resources.WWC002_009_E)
                Case Else
            End Select
        End Sub

        Private Sub _btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _btnCancel.Click
            Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
            Me.Close()
        End Sub

        Private Sub _btnBrowse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _btnBrowse.Click
            If Me._folderBrowserDialog.ShowDialog() = Windows.Forms.DialogResult.OK Then
                Me._cmbProjectFolderName.Text = Me._folderBrowserDialog.SelectedPath
            End If
        End Sub

        Private Sub _txtProjectName_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles _txtProjectName.LostFocus
            _txtProjectName.Text = IO.Path.GetFileNameWithoutExtension(_txtProjectName.Text.Trim) & PROJECT_EXTEND
        End Sub

        Private Sub NewProjectDialog_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
            _txtProjectName.Text = PROJECT_NONAME & PROJECT_EXTEND
        End Sub

        Private Function InputCheck() As Integer
            Dim result As Integer
            If IO.Path.GetFileNameWithoutExtension(Me._txtProjectName.Text.Trim) = String.Empty Then
                result = 1
            ElseIf Me._cmbProjectFolderName.Text.Trim = String.Empty Then
                result = 2
            ElseIf Not IO.Directory.Exists(Me._cmbProjectFolderName.Text.Trim) Then
                result = 3
            Else
                result = 0
            End If
            Return result
        End Function

    End Class
End Namespace
