'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  MyOpenProjectDialog.vb                                  --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Dialogues                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Windows.Forms
Namespace Dialogues
    Public Class MyOpenProjectDialog
        Private _openProjectDialog As OpenFileDialog

        Private Const DLG_TITLE As String = "vWFNgJ"
        Private Const DLG_FILTER As String = "WomenWC vWFNgt@C(*.wwc)|*.wwc|ׂẴt@C(*.*)|*.*"

        Public Sub New()
            _openProjectDialog = New OpenFileDialog
            _openProjectDialog.CheckFileExists = True
            _openProjectDialog.CheckPathExists = True
            _openProjectDialog.RestoreDirectory = True
            _openProjectDialog.Filter = DLG_FILTER
            _openProjectDialog.Multiselect = False
            _openProjectDialog.Title = DLG_TITLE

        End Sub

        Public ReadOnly Property FileName() As String
            Get
                Return _openProjectDialog.FileName
            End Get
        End Property

        Public Function ShowDialog() As DialogResult
            Return _openProjectDialog.ShowDialog
        End Function

    End Class
End Namespace
