'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  MyOpenFileDialog.vb                                     --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Dialogues                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Windows.Forms
Imports System.Text
Imports WomenWC.Managers.Manager

Namespace Dialogues
    Public Class MyOpenFileDialog
        Private _openFileDialog As OpenFileDialog

        Private Const DLG_TITLE As String = "t@CJ"

        Public Sub New()
            _openFileDialog = New OpenFileDialog
            _openFileDialog.CheckFileExists = True
            _openFileDialog.CheckPathExists = True
            _openFileDialog.Multiselect = False
            _openFileDialog.RestoreDirectory = True
            _openFileDialog.Title = DLG_TITLE
        End Sub

        Public ReadOnly Property FileName() As String
            Get
                Return _openFileDialog.FileName
            End Get
        End Property

        Public Function ShowDialog() As DialogResult
            _openFileDialog.Filter = SettingManager.SettingInfo.FileFilter
            Return _openFileDialog.ShowDialog
        End Function

    End Class
End Namespace
