/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class BoundedList
implements List {
    private LinkedList m_list = new LinkedList();
    private int m_maxItems = 0;
    private int m_count = 0;
    private int m_index = 0;
    private static final int LINE_WIDTH = 80;

    public int lastIndexOf(Object o) {
        return this.m_list.lastIndexOf(o);
    }

    public Object[] toArray() {
        return this.m_list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.m_list.toArray(a);
    }

    public boolean isFull() {
        return this.m_count >= this.m_maxItems;
    }

    public boolean isEmpty() {
        return this.m_count == 0;
    }

    public BoundedList(int maxItems) {
        this.m_maxItems = maxItems;
    }

    public synchronized void setMaxItems(int max) {
        this.m_maxItems = max;
    }

    public synchronized Object get(int i) {
        return this.m_list.get(i);
    }

    public synchronized void clear() {
        this.m_list.clear();
        this.m_count = 0;
    }

    public synchronized boolean add(Object o) {
        if (this.isFull()) {
            while (this.isFull()) {
                this.m_list.removeFirst();
                --this.m_count;
            }
            this.m_list.addLast(o);
            ++this.m_count;
        } else {
            this.m_list.add(o);
            ++this.m_count;
        }
        return true;
    }

    public int size() {
        return this.m_count;
    }

    public String getFormattedText() {
        StringBuffer sb = new StringBuffer(this.m_count * 80);
        int i = 0;
        while (i < this.m_count) {
            sb.append(this.m_list.get(i) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public void dump() {
        System.out.println("List contents");
        int i = 0;
        while (i < this.m_count) {
            System.out.println(String.valueOf(i) + ": " + this.m_list.get(i));
            ++i;
        }
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        return this.m_list.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.m_list.containsAll(c);
    }

    public int indexOf(Object o) {
        return this.m_list.indexOf(o);
    }

    public Iterator iterator() {
        return this.m_list.iterator();
    }

    public ListIterator listIterator() {
        return this.m_list.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.m_list.listIterator(index);
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        boolean result = this.m_list.remove(o);
        if (result) {
            --this.m_count;
        }
        return result;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.m_list.subList(fromIndex, toIndex);
    }
}

