/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Color;
import org.graysky.eclipse.logwatcher.LogwatcherPlugin;
import org.graysky.eclipse.logwatcher.filters.AddTaskAction;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.filters.FilterAction;
import org.graysky.eclipse.logwatcher.filters.HighlightAction;
import org.graysky.eclipse.logwatcher.filters.IgnoreAction;
import org.graysky.eclipse.logwatcher.wizards.AddTaskOptionsPage;
import org.graysky.eclipse.logwatcher.wizards.HighlightOptionsPage;
import org.graysky.eclipse.logwatcher.wizards.IgnoreOptionsPage;
import org.graysky.eclipse.logwatcher.wizards.NewFilterWizardStart;

public class NewFilterWizard
extends Wizard {
    private boolean m_editMode = false;
    private Filter m_filter;
    private boolean m_canFinish = false;
    private NewFilterWizardStart m_startPage = new NewFilterWizardStart("start");
    private HighlightOptionsPage m_highlightPage = new HighlightOptionsPage("highlight_options");
    private IgnoreOptionsPage m_ignorePage = new IgnoreOptionsPage("ignore_options");
    private AddTaskOptionsPage m_taskPage = new AddTaskOptionsPage("addTask_options");

    public NewFilterWizard(boolean editMode) {
        this.m_editMode = editMode;
        this.setWindowTitle("New Filter Wizard");
        this.initPages();
    }

    public boolean performFinish() {
        this.m_filter = this.m_startPage.getFilter();
        switch (this.m_startPage.getActionType()) {
            case 0: {
                HighlightAction a = new HighlightAction(this.m_highlightPage.getColor());
                this.addFilterAction(a);
                break;
            }
            case 1: {
                this.addFilterAction(new IgnoreAction());
                break;
            }
            case 2: {
                AddTaskAction ta = new AddTaskAction(this.m_taskPage.getDescription(), this.m_taskPage.getPriority(), (IResource)LogwatcherPlugin.getWorkspace().getRoot());
                this.addFilterAction(ta);
            }
        }
        return true;
    }

    public boolean performCancel() {
        Color c = this.m_highlightPage.getColor();
        if (c != null) {
            c.dispose();
        }
        return super.performCancel();
    }

    protected void initPages() {
        this.addPage((IWizardPage)this.m_startPage);
        this.addPage((IWizardPage)this.m_highlightPage);
        this.addPage((IWizardPage)this.m_ignorePage);
        this.addPage((IWizardPage)this.m_taskPage);
    }

    public void setFilter(Filter f) {
        this.m_filter = f;
    }

    public void addFilterAction(FilterAction a) {
        this.m_filter.addAction(a);
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public boolean canFinish() {
        if (this.m_startPage.isPageComplete()) {
            switch (this.m_startPage.getActionType()) {
                case 0: {
                    if (!this.m_highlightPage.isPageComplete()) break;
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    if (!this.m_taskPage.isPageComplete()) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void setCanFinish(boolean canFinish) {
        this.m_canFinish = canFinish;
    }

    public boolean isEditMode() {
        return this.m_editMode;
    }

    public void setEditMode(boolean editMode) {
        this.m_editMode = editMode;
    }
}

