/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.watchers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.graysky.eclipse.logwatcher.LogwatcherPlugin;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.watchers.WatcherUpdateListener;
import org.graysky.eclipse.util.BoundedList;

public class TextFileWatcher
extends Thread {
    private File m_file = null;
    private BufferedReader m_reader = null;
    private int m_interval = 1;
    private int m_numLines = 100;
    private boolean m_active = false;
    private Vector m_listeners = new Vector();
    private boolean m_console = false;
    private Vector m_filters = new Vector();
    private BoundedList m_list = null;

    public TextFileWatcher(String filename, int interval, int numLines) throws FileNotFoundException, IOException {
        this(new File(filename), interval, numLines);
    }

    public TextFileWatcher(File file, int interval, int numLines) throws FileNotFoundException, IOException {
        this.m_file = file;
        this.m_interval = interval;
        this.m_numLines = numLines;
        this.m_reader = new BufferedReader(new FileReader(this.m_file));
    }

    public void halt() {
        this.m_active = false;
        this.interrupt();
    }

    public void setConsole(boolean b) {
        this.m_console = b;
    }

    public void addListener(WatcherUpdateListener listener) {
        this.m_listeners.add(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.m_active = true;
        this.m_list = new BoundedList(this.m_numLines);
        String line = null;
        long size = 0L;
        boolean firstUpdate = false;
        while (this.m_active) {
            boolean updated = false;
            boolean truncated = false;
            truncated = false;
            if (this.m_file.length() < size) {
                truncated = true;
            }
            size = this.m_file.length();
            try {
                if (truncated) {
                    this.m_list.add("*** File truncated ***");
                    updated = true;
                    this.m_reader.close();
                    this.m_reader = new BufferedReader(new FileReader(this.m_file));
                    while ((line = this.m_reader.readLine()) != null) {
                    }
                } else if (!this.m_file.exists()) {
                    this.m_list.add("*** File deleted ***");
                    updated = true;
                    this.m_active = false;
                } else {
                    while (true) {
                        if ((line = this.m_reader.readLine()) == null) {
                            firstUpdate = true;
                            break;
                        }
                        if (line.length() <= 0) continue;
                        Vector vector = this.m_filters;
                        synchronized (vector) {
                            Iterator iter = this.m_filters.iterator();
                            while (iter.hasNext()) {
                                Filter f = (Filter)iter.next();
                                if (!f.matches(line)) continue;
                                line = f.handleWatcherMatch(line, firstUpdate);
                            }
                        }
                        if (line == null) continue;
                        updated = true;
                        this.m_list.add(line);
                        if (!this.m_console) continue;
                        System.out.println(line);
                    }
                }
                if (updated) {
                    this.notifyListeners();
                }
                Thread.sleep(this.m_interval * 1000);
                this.m_list.clear();
            }
            catch (IOException e) {
                LogwatcherPlugin.getDefault().logError("Error reading from log file", e);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.m_reader.close();
            return;
        }
        catch (Exception e) {
            LogwatcherPlugin.getDefault().logError("Error closing log file reader", e);
        }
    }

    protected synchronized void notifyListeners() {
        Iterator i = this.m_listeners.iterator();
        while (i.hasNext()) {
            WatcherUpdateListener l = (WatcherUpdateListener)i.next();
            l.update(this.m_list);
        }
    }

    public String getFilename() {
        return this.m_file.getAbsolutePath();
    }

    public int getInterval() {
        return this.m_interval;
    }

    public void setInterval(int interval) {
        this.m_interval = interval;
    }

    public void clear() {
        this.m_list.clear();
        this.notifyListeners();
    }

    public void setNumLines(int numLines) {
        this.m_numLines = numLines == 0 ? Integer.MAX_VALUE : numLines;
        this.m_list.setMaxItems(this.m_numLines);
    }

    public int getNumLines() {
        return this.m_numLines;
    }

    public void setFilters(Vector filters) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            this.m_filters = filters;
        }
    }
}

