/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindDialog
extends Dialog {
    private Text m_findText = null;
    private IFindReplaceTarget m_target = null;
    private Button m_caseSensitive = null;
    private Button m_wrap = null;
    private Button m_wholeWord = null;
    private Button m_incremental = null;
    private Button m_findButton = null;
    private Label m_statusLabel = null;
    private int m_offset = 0;

    public FindDialog(Shell parentShell, IFindReplaceTarget target) {
        super(parentShell);
        this.m_target = target;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Find");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText("Find:");
        this.m_findText = new Text(composite, 2048);
        this.m_findText.setTextLimit(200);
        GridData gridData = new GridData();
        gridData.widthHint = 160;
        this.m_findText.setLayoutData((Object)gridData);
        this.m_findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FindDialog.this.m_findText.getText().length() > 0) {
                    FindDialog.this.m_findButton.setEnabled(true);
                    if (FindDialog.this.m_incremental.getSelection()) {
                        FindDialog.this.m_offset = FindDialog.this.search(FindDialog.this.m_findText.getText());
                    }
                } else {
                    FindDialog.this.m_findButton.setEnabled(false);
                }
            }
        });
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setText("Options");
        GridLayout glayout = new GridLayout(2, false);
        optionsGroup.setLayout((Layout)glayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        optionsGroup.setLayoutData((Object)gridData);
        this.m_caseSensitive = new Button((Composite)optionsGroup, 32);
        this.m_caseSensitive.setText("Case Sensitive");
        this.m_wrap = new Button((Composite)optionsGroup, 32);
        this.m_wrap.setText("Wrap Search");
        this.m_wholeWord = new Button((Composite)optionsGroup, 32);
        this.m_wholeWord.setText("Whole Word");
        this.m_incremental = new Button((Composite)optionsGroup, 32);
        this.m_incremental.setText("Incremental");
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_findButton = new Button(parent, 8);
        this.m_findButton.setText("Find");
        this.m_findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int offset = FindDialog.this.search(FindDialog.this.m_findText.getText());
                if (offset == -1) {
                    if (FindDialog.this.m_wrap.getSelection()) {
                        FindDialog.this.m_offset = 0;
                    }
                } else {
                    FindDialog.this.m_offset = offset + 1;
                }
            }
        });
        this.m_findButton.setEnabled(false);
        this.getShell().setDefaultButton(this.m_findButton);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.m_findButton.setLayoutData((Object)gridData);
        this.m_statusLabel = new Label(parent, 0);
        this.m_statusLabel.setText("                                       ");
        Button closeButton = new Button(parent, 8);
        closeButton.setText("Close");
        gridData = new GridData(128);
        closeButton.setLayoutData((Object)gridData);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FindDialog.this.close();
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected int search(String text) {
        int offset = this.m_target.findAndSelect(this.m_offset, text, true, this.m_caseSensitive.getSelection(), this.m_wholeWord.getSelection());
        if (offset == -1) {
            this.m_statusLabel.setText("String not found");
            this.m_statusLabel.redraw();
        }
        return offset;
    }
}

