/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.filters.FilterLoader;
import org.graysky.eclipse.util.BoundedList;
import org.graysky.eclipse.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogwatcherPlugin
extends AbstractUIPlugin {
    private static LogwatcherPlugin plugin;
    private ResourceBundle resourceBundle;
    private FontRegistry m_fontRegistry = new FontRegistry();
    private File m_recentWatchesFile;
    private List m_recentWatches = new BoundedList(20);
    private List m_savedFilters = new ArrayList();
    private static final String LOG_FONT = "logwatcherFont";
    private static final String SAVE_WATCHERS = "saveWatchers";
    private static final String RECENT_WATCHERS_FILE = "recentWatchers";
    private static final String SAVED_FILTERS_FILE = "savedFilters.xml";

    public LogwatcherPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.graysky.eclipse.logwatcher.LogwatcherPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.m_recentWatchesFile = this.getRecentWatchesFile();
        try {
            if (this.m_recentWatchesFile.exists()) {
                this.initRecentWatchers();
            }
        }
        catch (Exception e) {
            this.logError("Error loading recent watchers", e);
        }
        try {
            File savedFilters = this.getSavedFiltersFile();
            if (savedFilters.exists()) {
                this.initSavedFilters(savedFilters);
            }
        }
        catch (Exception e) {
            this.logError("Error loading recent watchers", e);
        }
    }

    private File getRecentWatchesFile() {
        IPath path = this.getStateLocation();
        path = path.addTrailingSeparator();
        path = path.append(RECENT_WATCHERS_FILE);
        return path.toFile();
    }

    private void initRecentWatchers() throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(this.m_recentWatchesFile));
        while ((line = reader.readLine()) != null) {
            this.m_recentWatches.add(line);
        }
    }

    public static LogwatcherPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LogwatcherPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        store.setDefault(SAVE_WATCHERS, false);
    }

    public void logError(String msg, Exception e) {
        Status s = new Status(4, "logwatcher", 1, msg, (Throwable)e);
        this.getLog().log((IStatus)s);
    }

    public Font getFont(String name) {
        return this.m_fontRegistry.get(name);
    }

    public void putFont(String name, FontData[] data) {
        this.m_fontRegistry.put(name, data);
    }

    public void startup() throws CoreException {
        super.startup();
        if (this.getPreferenceStore().contains(LOG_FONT)) {
            this.m_fontRegistry.put(LOG_FONT, PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)LOG_FONT));
        }
    }

    public void addSavedFilter(Filter filter) {
        this.m_savedFilters.add(filter);
        this.persistSavedFilters();
    }

    public List getSavedFilters() {
        return Collections.unmodifiableList(this.m_savedFilters);
    }

    public List getRecentWatches() {
        return Collections.unmodifiableList(this.m_recentWatches);
    }

    public void addRecentWatch(String filename) {
        if (this.m_recentWatches.contains(filename)) {
            this.m_recentWatches.remove(filename);
        }
        this.m_recentWatches.add(filename);
        this.persistRecentWatches();
    }

    /*
     * Exception decompiling
     */
    private synchronized void persistRecentWatches() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 116->120)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initSavedFilters(File file) throws Exception {
        FilterLoader loader = new FilterLoader();
        Vector filters = loader.loadFilters(new FileReader(file));
        this.m_savedFilters.addAll(filters);
    }

    private synchronized void persistSavedFilters() {
        File path = this.getSavedFiltersFile();
        try {
            Document doc = XmlUtils.createDocument();
            Element watcher = doc.createElement("filters");
            doc.appendChild(watcher);
            Iterator iter = this.m_savedFilters.iterator();
            while (iter.hasNext()) {
                Filter element = (Filter)iter.next();
                element.toXML(doc, watcher);
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(path);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            LogwatcherPlugin.getDefault().logError("Error saving filters", e);
        }
    }

    private File getSavedFiltersFile() {
        IPath path = LogwatcherPlugin.getDefault().getStateLocation();
        path = path.addTrailingSeparator();
        path = path.append(SAVED_FILTERS_FILE);
        return path.toFile();
    }
}

